/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.json;

import com.aptana.json.IContextHandler;
import com.aptana.json.IState;
import com.aptana.json.Schema;
import com.aptana.json.SchemaObject;
import com.aptana.json.SchemaProperty;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public class SchemaHandler
implements IContextHandler {
    private Schema _currentSchema;
    private SchemaObject _currentType;
    private String _currentTypeName;
    private SchemaProperty _currentProperty;
    private String _currentString;
    private Boolean _currentBoolean;

    public void addElement(String elementTypeName, IState elementType) {
        TypeName t = TypeName.get(elementTypeName);
        switch (t) {
            case SCHEMA: {
                break;
            }
            case TYPE: {
                this._currentSchema.addType(this._currentTypeName, this._currentType);
                this._currentTypeName = null;
                this._currentType = null;
                break;
            }
            case PROPERTY: {
                this._currentType.addProperty(this._currentProperty);
                this._currentProperty = null;
            }
        }
    }

    public void createType(String typeName, IState type, Object value) {
        TypeName t = TypeName.get(typeName);
        switch (t) {
            case SCHEMA: {
                this._currentSchema = new Schema();
                break;
            }
            case TYPE: {
                this._currentType = this._currentSchema.createObject();
                break;
            }
            case PROPERTY: {
                this._currentProperty = this._currentSchema.createProperty();
                break;
            }
            case STRING: {
                this._currentString = (String)value;
                break;
            }
            case BOOLEAN: {
                this._currentBoolean = (Boolean)value;
            }
        }
    }

    public Schema getSchema() {
        return this._currentSchema;
    }

    public void setProperty(String propertyName, String propertyTypeName, IState propertyType) {
        PropertyName p = PropertyName.get(propertyName);
        switch (p) {
            case NAME: {
                if (this._currentProperty != null) {
                    this._currentProperty.setName(this._currentString);
                } else if (this._currentType != null) {
                    this._currentTypeName = this._currentString;
                } else if (this._currentSchema != null) {
                    this._currentSchema.setName(this._currentString);
                }
                this._currentString = null;
                break;
            }
            case VERSION: {
                if (this._currentSchema != null) {
                    this._currentSchema.setVersion(this._currentString);
                }
                this._currentString = null;
                break;
            }
            case DESCRIPTION: {
                if (this._currentProperty != null) {
                    this._currentProperty.setDescription(this._currentString);
                } else if (this._currentType != null) {
                    this._currentType.setDescription(this._currentString);
                } else if (this._currentSchema != null) {
                    this._currentSchema.setDescription(this._currentString);
                }
                this._currentString = null;
                break;
            }
            case RESULT: {
                if (this._currentSchema != null) {
                    this._currentSchema.setResult(this._currentString);
                }
                this._currentString = null;
                break;
            }
            case TYPE: {
                if (this._currentProperty != null) {
                    this._currentProperty.setTypeName(this._currentString);
                }
                this._currentString = null;
                break;
            }
            case EXAMPLE: {
                if (this._currentProperty != null) {
                    this._currentProperty.setExample(this._currentString);
                }
                this._currentString = null;
                break;
            }
            case OPTIONAL: {
                if (this._currentProperty != null) {
                    this._currentProperty.setOptional(this._currentBoolean);
                }
                this._currentBoolean = null;
                break;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum PropertyName {
        UNDEFINED(""),
        NAME("name"),
        VERSION("version"),
        DESCRIPTION("description"),
        RESULT("result"),
        TYPES("types"),
        PROPERTIES("properties"),
        TYPE("type"),
        EXAMPLE("example"),
        OPTIONAL("optional");

        private static Map<String, PropertyName> NAME_MAP;
        private String _name;

        static {
            NAME_MAP = new HashMap<String, PropertyName>();
            for (PropertyName property : EnumSet.allOf(PropertyName.class)) {
                NAME_MAP.put(property.getName(), property);
            }
        }

        public static PropertyName get(String name) {
            PropertyName result = UNDEFINED;
            if (NAME_MAP.containsKey(name)) {
                result = NAME_MAP.get(name);
            }
            return result;
        }

        private PropertyName(String name) {
            this._name = name;
        }

        public String getName() {
            return this._name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TypeName {
        UNDEFINED(""),
        SCHEMA("Schema"),
        TYPE("Type"),
        PROPERTY("Property"),
        STRING("String"),
        BOOLEAN("Boolean");

        private static Map<String, TypeName> NAME_MAP;
        private String _name;

        static {
            NAME_MAP = new HashMap<String, TypeName>();
            for (TypeName type : EnumSet.allOf(TypeName.class)) {
                NAME_MAP.put(type.getName(), type);
            }
        }

        public static TypeName get(String name) {
            TypeName result = UNDEFINED;
            if (NAME_MAP.containsKey(name)) {
                result = NAME_MAP.get(name);
            }
            return result;
        }

        private TypeName(String name) {
            this._name = name;
        }

        public String getName() {
            return this._name;
        }
    }
}

